******** UPDATES ***************************************************
7/30/02: ADDED ADJUTMENTS FOR FOOD AT HOME FOR 84-87
3/16/08: ADDED ADJUTMENT TO WGTS TO INCLUDE BOTH 955 AND 961 AND
	 CHANGED QYEAR FOR THE FORMER TO 955
8/2/08: ADDED ADJUSTMENTS FOR FOOD, HOUSING, AND ENTERTAINMENT,
        MERGING IN FIX_FOOD_SHELT*.SAS

*****************************************************************;

******** NOTE ***************************************************
I add 9000000 to newid for 84-85 data because this variable
started over at one starting in 1986, which caused repeated IDs
when merging 84-85 with later years
*****************************************************************;

LIBNAME state '~/jim/data/cex_state';
LIBNAME alldat '~/jim/data';

*%INCLUDE "~/jim/gzipseq.mcr";   
%INCLUDE "~/jim/poverty/include/infile_cons.mcr";

*******  FAMILY FILES   **********;

*XXXXXXXXXXXXXXXX ADD 1980 XXXXXXXXXXX;


filename fmly832 pipe 'gunzip -c ~/cex84/da8598.fmly.q832.gz';
filename fmly833 pipe 'gunzip -c ~/jim/data/ce8400/da8598.fmly.q833.gz';
filename fmly834 pipe 'gunzip -c ~/jim/data/ce8400/da8598.fmly.q834.gz';

filename fmly841 pipe 'gunzip -c ~/jim/data/ce8400/da8671.fmly.q841.gz';
filename fmly842 pipe 'gunzip -c ~/jim/data/ce8400/da8671.fmly.q842.gz';
filename fmly843 pipe 'gunzip -c ~/jim/data/ce8400/da8671.fmly.q843.gz';
filename fmly844 pipe 'gunzip -c ~/jim/data/ce8400/da8671.fmly.q844.gz';

filename fmly851 pipe 'gunzip -c ~/jim/data/ce8400/da8904.fmly.q851.gz';
filename fmly852 pipe 'gunzip -c ~/jim/data/ce8400/da8904.fmly.q852.gz';
filename fmly853 pipe 'gunzip -c ~/jim/data/ce8400/da8904.fmly.q853.gz';
filename fmly854 pipe 'gunzip -c ~/jim/data/ce8400/da8904.fmly.q854.gz';
filename fmly855 pipe 'gunzip -c ~/jim/data/ce8400/08904-0017-Data.txt.gz';

filename fmly861 pipe 'gunzip -c ~/jim/data/ce8400/da9113.fmly.q861.gz';
filename fmly862 pipe 'gunzip -c ~/jim/data/ce8400/da9113.fmly.q862.gz';
filename fmly863 pipe 'gunzip -c ~/jim/data/ce8400/da9113.fmly.q863.gz';
filename fmly864 pipe 'gunzip -c ~/jim/data/ce8400/da9113.fmly.q864.gz';

filename fmly871 pipe 'gunzip -c ~/jim/data/ce8400/da9332.fmly.q871.gz';
filename fmly872 pipe 'gunzip -c ~/jim/data/ce8400/da9332.fmly.q872.gz';
filename fmly873 pipe 'gunzip -c ~/jim/data/ce8400/da9332.fmly.q873.gz';
filename fmly874 pipe 'gunzip -c ~/jim/data/ce8400/da9332.fmly.q874.gz';

filename fmly881 pipe 'gunzip -c ~/jim/data/ce8400/da9842.fmly.q881.gz';
filename fmly882 pipe 'gunzip -c ~/jim/data/ce8400/da9842.fmly.q882.gz';
filename fmly883 pipe 'gunzip -c ~/jim/data/ce8400/da9842.fmly.q883.gz';
filename fmly884 pipe 'gunzip -c ~/jim/data/ce8400/da9842.fmly.q884.gz';

filename fmly891 pipe 'gunzip -c ~/jim/data/ce8400/da9841.fmly.q891.gz';
filename fmly892 pipe 'gunzip -c ~/jim/data/ce8400/da9841.fmly.q892.gz';
filename fmly893 pipe 'gunzip -c ~/jim/data/ce8400/da9841.fmly.q893.gz';
filename fmly894 pipe 'gunzip -c ~/jim/data/ce8400/da9841.fmly.q894.gz';

filename fmly901 pipe 'gunzip -c ~/jim/data/ce8400/da9817.fmly.q901.gz';
filename fmly902 pipe 'gunzip -c ~/jim/data/ce8400/da9817.fmly.q902.gz';
filename fmly903 pipe 'gunzip -c ~/jim/data/ce8400/da9817.fmly.q903.gz';
filename fmly904 pipe 'gunzip -c ~/jim/data/ce8400/da9817.fmly.q904.gz';

filename fmly911 pipe 'gunzip -c ~/jim/data/ce8400/da6262.fmly.q911.gz';
filename fmly912 pipe 'gunzip -c ~/jim/data/ce8400/da6262.fmly.q912.gz';
filename fmly913 pipe 'gunzip -c ~/jim/data/ce8400/da6262.fmly.q913.gz';
filename fmly914 pipe 'gunzip -c ~/jim/data/ce8400/da6262.fmly.q914.gz';

filename fmly921 pipe 'gunzip -c ~/jim/data/ce8400/06372-0001-Data.txt.gz';
filename fmly922 pipe 'gunzip -c ~/jim/data/ce8400/06372-0005-Data.txt.gz';
filename fmly923 pipe 'gunzip -c ~/jim/data/ce8400/06372-0009-Data.txt.gz';
filename fmly924 pipe 'gunzip -c ~/jim/data/ce8400/06372-0013-Data.txt.gz';

filename fmly931 pipe 'gunzip -c ~/jim/data/ce8400/06543-0001-Data.txt.gz';
filename fmly932 pipe 'gunzip -c ~/jim/data/ce8400/06543-0003-Data.txt.gz';
filename fmly933 pipe 'gunzip -c ~/jim/data/ce8400/06543-0005-Data.txt.gz';
filename fmly934 pipe 'gunzip -c ~/jim/data/ce8400/06543-0007-Data.txt.gz';

filename fmly941 pipe 'gunzip -c ~/jim/data/ce8400/da6710.fmly.q941.gz';
filename fmly942 pipe 'gunzip -c ~/jim/data/ce8400/da6710.fmly.q942.gz';
filename fmly943 pipe 'gunzip -c ~/jim/data/ce8400/da6710.fmly.q943.gz';
filename fmly944 pipe 'gunzip -c ~/jim/data/ce8400/da6710.fmly.q944.gz';

filename fmly951 pipe 'gunzip -c ~/jim/data/ce8400/da2264.fmly.q951.gz';
filename fmly952 pipe 'gunzip -c ~/jim/data/ce8400/da2264.fmly.q952.gz';
filename fmly953 pipe 'gunzip -c ~/jim/data/ce8400/da2264.fmly.q953.gz';
filename fmly954 pipe 'gunzip -c ~/jim/data/ce8400/da2264.fmly.q954.gz';
filename fmly955 pipe 'gunzip -c ~/jim/data/ce8400/da2264.fmly.q961.gz';

filename fmly961 pipe 'gunzip -c ~/jim/data/ce8400/da2794.fmly961.gz';
filename fmly962 pipe 'gunzip -c ~/jim/data/ce8400/da2794.fmly962.gz';
filename fmly963 pipe 'gunzip -c ~/jim/data/ce8400/da2794.fmly963.gz';
filename fmly964 pipe 'gunzip -c ~/jim/data/ce8400/da2794.fmly964.gz';

filename fmly971 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi971X.txt.gz';
filename fmly972 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi972.txt.gz';
filename fmly973 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi973.txt.gz';
filename fmly974 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi974.txt.gz';

filename fmly981 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi981X.txt.gz';
filename fmly982 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi982.txt.gz';
filename fmly983 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi983.txt.gz';
filename fmly984 pipe 'gunzip -c ~/jim/data/ce8400/fmlyi984.txt.gz';

filename fmly991 pipe 'gunzip -c ~/jim/data/ce8400/da3228.fmly991.gz';
filename fmly992 pipe 'gunzip -c ~/jim/data/ce8400/da3228.fmly992.gz';
filename fmly993 pipe 'gunzip -c ~/jim/data/ce8400/da3228.fmly993.gz';
filename fmly994 pipe 'gunzip -c ~/jim/data/ce8400/da3228.fmly994.gz';

filename fmly001 pipe 'gunzip -c ~/jim/data/ce8400/da3396.fmly001.gz';
filename fmly002 pipe 'gunzip -c ~/jim/data/ce8400/da3396.fmly002.gz';
filename fmly003 pipe 'gunzip -c ~/jim/data/ce8400/da3396.fmly003.gz';
filename fmly004 pipe 'gunzip -c ~/jim/data/ce8400/da3396.fmly004.gz';


options obs=max;

/*

***************  83:2  *************************************************;

DATA famly832;  
INFILE fmly832 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2;
INPUT &dem83; 

qyear=832;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  83:3  *************************************************;

DATA famly833;  
INFILE fmly833 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2;
INPUT &dem83; 

qyear=833;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  83:4  *************************************************;

DATA famly834;  
INFILE fmly834 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2;
INPUT &dem83; 

qyear=834;
newid=9000000+newid;
*PROC MEANS;
RUN;

*/
***************  84:1  *************************************************;

DATA famly841;  
INFILE fmly841 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem84 &con84; 

qyear=841;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  84:2  *************************************************;

DATA famly842;  
INFILE fmly842 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem84 &con84; 

qyear=842;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  84:3  *************************************************;

DATA famly843;  
INFILE fmly843 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem84 &con84; 

qyear=843;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  84:4  *************************************************;

DATA famly844;  
INFILE fmly844 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem84 &con84; 

qyear=844;
newid=9000000+newid;
*PROC MEANS;
RUN;


***************  85:1  *************************************************;

DATA famly851;  
INFILE fmly851 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem85 &con85; 

qyear=851;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  85:2  *************************************************;

DATA famly852;  
INFILE fmly852 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem85 &con85; 

qyear=852;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  85:3  *************************************************;

DATA famly853;  
INFILE fmly853 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem85 &con85; 

qyear=853;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  85:4  *************************************************;

DATA famly854;  
INFILE fmly854 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem85 &con85; 

qyear=854;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  85:5  *************************************************;

DATA famly855;  
INFILE fmly855 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem85 &con85; 

qyear=855;
newid=9000000+newid;
*PROC MEANS;
RUN;

***************  86:1  *************************************************;

DATA famly861;  
INFILE fmly861 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem86 &con8693; 

qyear=861;
*PROC MEANS; 
RUN;

***************  86:2  *************************************************;

DATA famly862;  
INFILE fmly862 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem86 &con8693; 

qyear=862;
*PROC MEANS; 
RUN;

***************  86:3  *************************************************;

DATA famly863;  
INFILE fmly863 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem86 &con8693; 

qyear=863;
*PROC MEANS; 
RUN;

***************  86:4  *************************************************;

DATA famly864;  
INFILE fmly864 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem86 &con8693; 

qyear=864;
*PROC MEANS; 
RUN;

***************  87:1  *************************************************;

DATA famly871;  
INFILE fmly871 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem87 &con8693; 

qyear=871;
*PROC MEANS; 
RUN;

***************  87:2  *************************************************;

DATA famly872;  
INFILE fmly872 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem87 &con8693; 

qyear=872;
*PROC MEANS; 
RUN;

***************  87:3  *************************************************;

DATA famly873;  
INFILE fmly873 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem87 &con8693;

qyear=873;
*PROC MEANS; 
RUN;

***************  87:4  *************************************************;

DATA famly874;  
INFILE fmly874 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem87 &con8693; 

qyear=874;
*PROC MEANS; 
RUN;

***************  88:1  *************************************************;

DATA famly881;  
INFILE fmly881 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem88 &con8693;

qyear=881;
RUN;

***************  88:2  *************************************************;

DATA famly882;  
INFILE fmly882 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem88 &con8693; 

qyear=882;

RUN;

***************  88:3  *************************************************;


DATA famly883;  
INFILE fmly883 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem88 &con8693;

qyear=883;

RUN;

***************  88:4  *************************************************;

DATA famly884;  
INFILE fmly884 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem88 &con8693;

qyear=884;

RUN;

***************  89:1  *************************************************;


DATA famly891;  
INFILE fmly891 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem89 &con8693;

qyear=891;

RUN;

***************  89:2  *************************************************;


DATA famly892;  
INFILE fmly892 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem89 &con8693; 

qyear=892;

RUN;

***************  89:3  *************************************************;


DATA famly893;  
INFILE fmly893 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem89 &con8693;  

qyear=893;

RUN;


***************  89:4  *************************************************;

DATA famly894;  
INFILE fmly894 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem89 &con8693;  

qyear=894;

RUN;


***************  90:1  *************************************************;


DATA famly901;  
INFILE fmly901 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem90 &con8693;  

qyear=901;

RUN;

***************  90:2  *************************************************;


DATA famly902;  
INFILE fmly902 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem90 &con8693;  

qyear=902;

RUN;

***************  90:3  *************************************************;


DATA famly903;  
INFILE fmly903 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem90 &con8693;  

qyear=903;

RUN;


***************  90:4  *************************************************;

DATA famly904;  
INFILE fmly904 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem90 &con8693;  

qyear=904;

RUN;

***************  91:1  *************************************************;

DATA famly911;  
INFILE fmly911 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem91 &con8693; 

qyear=911;
RUN;

***************  91:2  *************************************************;


DATA famly912;  
INFILE fmly912 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem91 &con8693;  

qyear=912;

RUN;

***************  91:3  *************************************************;

DATA famly913;  
INFILE fmly913 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem91 &con8693;  

qyear=913;

RUN;

***************  91:4  *************************************************;

DATA famly914;  
INFILE fmly914 lrecl=3400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem91 &con8693;  

qyear=914;

RUN;

***************  92:1  *************************************************;

DATA famly921;  
INFILE fmly921 lrecl=2400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem92 &con8693;

qyear=921; 

RUN;

***************  92:2  *************************************************;

DATA famly922;  
INFILE fmly922 lrecl=2400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem92 &con8693;

qyear=922;

RUN;

***************  92:3  *************************************************;

DATA famly923;  
INFILE fmly923 lrecl=2400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem92 &con8693;

qyear=923;

RUN;

***************  92:4  *************************************************;

DATA famly924;  
INFILE fmly924 lrecl=2400;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem92 &con8693;

qyear=924;

RUN;

***************  93:1  *************************************************;

DATA famly931;  
INFILE fmly931 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem93 &con8693;

qyear=931;

RUN;

***************  93:2  *************************************************;

DATA famly932;  
INFILE fmly932 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem93 &con8693;

qyear=932;

RUN;

***************  93:3  *************************************************;

DATA famly933;  
INFILE fmly933 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem93 &con8693;

qyear=933;

RUN;

***************  93:4  *************************************************;

DATA famly934;  
INFILE fmly934 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem93 &con8693;

qyear=934;

RUN;

***************  94:1  *************************************************;

DATA famly941;  
INFILE fmly941 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem94 &con9495;

qyear=941;

RUN;

***************  94:2  *************************************************;


DATA famly942;  
INFILE fmly942 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem94 &con9495; 

qyear=942;

RUN;

***************  94:3  *************************************************;

DATA famly943;  
INFILE fmly943 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem94 &con9495;
 
qyear=943; 

RUN;

***************  94:4  *************************************************;

DATA famly944;  
INFILE fmly944 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem94 &con9495; 

qyear=944; 

RUN;

***************  95:1  *************************************************;

DATA famly951;  
INFILE fmly951 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem95 &con9495;

qyear=951;

RUN;

***************  95:2  *************************************************;

DATA famly952;  
INFILE fmly952 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem95 &con9495;

qyear=952;

RUN;

***************  95:3  *************************************************;

DATA famly953;  
INFILE fmly953 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem95 &con9495;

qyear=953;

RUN;

***************  95:4  *************************************************;

DATA famly954;  
INFILE fmly954 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem95 &con9495;

qyear=954;

RUN;

***************  95:5  *************************************************;

DATA famly955;  
INFILE fmly955 lrecl=3600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem95 &con9495;

qyear=955;

RUN;
PROC SORT; 
BY newid;
RUN;

***************  96:1  *************************************************;

DATA famly961;  
INFILE fmly961 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem96 &con9698; 

*THERE ARE NO INTERVIEWS IN JAN. FOR 961 FILE, SO INFLATE WGT BY 3/2;
finlwt=finlwt*3/2;

qyear=961; 

RUN;
PROC SORT; 
BY newid;
RUN;

**************************************************************************
MERGE 95:5 AND 96:1 
BECAUSE THE CE SHIFTED TO 1990 WEIGHTS IN 1996, THESE 2 
DATASETS ARE NOT THE SAME OBS, ALTHOUGH THERE IS SOME OVERLAP.  WE USE OBS 
FROM BOTH DATASETS AND THEN ADJUST THE WEIGHTS ACCORDINGLY 
**************************************************************************;
DATA famly961; 
   MERGE famly955(in=in95 RENAME=(finlwt=wgt955))
         famly961(in=in96 RENAME=(finlwt=wgt961));
   BY newid;
 
IF in95 and in96 THEN dset=1; 
ELSE IF in95 THEN dset=2;
ELSE IF in96 THEN dset=3;
 
*Get the right weights for the combined 955 and 961 data;
IF dset=1 THEN finlwt=(wgt955+wgt961)/2;
   ELSE IF dset=2 THEN finlwt=wgt955/2;
   ELSE IF dset=3 THEN finlwt=wgt961/2;

DROP dset; 
RUN; 


***************  96:2  *************************************************;

DATA famly962;  
INFILE fmly962 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem96 &con9698;

qyear=962;

RUN;

***************  96:3  *************************************************;

DATA famly963;  
INFILE fmly963 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem96 &con9698;

qyear=963;

RUN;

***************  96:4  *************************************************;

DATA famly964;  
INFILE fmly964 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem96 &con9698;

qyear=964;

RUN;

***************  97:1  *************************************************;

DATA famly971;  
INFILE fmly971 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem97 &con9698;

qyear=971; 

RUN;

***************  97:2  *************************************************;

DATA famly972;  
INFILE fmly972 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem97 &con9698;

qyear=972;

RUN;

***************  97:3  *************************************************;

DATA famly973;  
INFILE fmly973 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem97 &con9698;

qyear=973;

RUN;

***************  97:4  *************************************************;

DATA famly974;  
INFILE fmly974 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem97 &con9698;

qyear=974;

RUN;

***************  98:1  *************************************************;

DATA famly981;  
INFILE fmly981 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem98 &con9698; 

qyear=981;

RUN;

***************  98:2  *************************************************;

DATA famly982;  
INFILE fmly982 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem98 &con9698; 

qyear=982;

RUN;

***************  98:3  *************************************************;

DATA famly983;  
INFILE fmly983 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem98 &con9698; 

qyear=983;

RUN;

***************  98:4  *************************************************;

DATA famly984;  
INFILE fmly984 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem98 &con9698; 

qyear=984;

RUN;

***************  99:1  *************************************************;

DATA famly991;  
INFILE fmly991 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem98 &con99; 

qyear=991;

RUN;

***************  99:2  *************************************************;

DATA famly992;  
INFILE fmly992 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con99; 

qyear=992;

RUN;

***************  99:3  *************************************************;

DATA famly993;  
INFILE fmly993 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con99; 

qyear=993;

RUN;

***************  99:4  *************************************************;

DATA famly994;  
INFILE fmly994 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con99; 

qyear=994;

RUN;

***************  00:1  *************************************************;

DATA famly001;  
INFILE fmly001 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con00; 

qyear=1001;

RUN;

***************  00:2  *************************************************;

DATA famly002;  
INFILE fmly002 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con00; 

qyear=1002;

RUN;

***************  00:3  *************************************************;

DATA famly003;  
INFILE fmly003 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con00; 

qyear=1003;

RUN;

***************  00:4  *************************************************;

DATA famly004;  
INFILE fmly004 lrecl=4600;
LENGTH intvyr $ 4 educ_ref $ 2 educa2 $ 2 inclass $ 2;
INPUT &dem9800 &con00; 

qyear=1004;

RUN;



*********************************************************
This stacking of the data is done in 2 steps because
they started over with NEWID's at 1 after the sample redesign
between 85-86. Note they did not restart NEWID when they 
did the sample redesign between 95-96.
*********************************************************;

DATA cexdat1;
MERGE
/*famly832 famly833 famly834*/
famly841 famly842 famly843 famly844
famly851 famly852 famly853 famly854 famly855;
BY newid;
RUN;

DATA cexdat2;
MERGE
famly861 famly862 famly863 famly864
famly871 famly872 famly873 famly874
famly881 famly882 famly883 famly884 
famly891 famly892 famly893 famly894  
famly901 famly902 famly903 famly904 
famly911 famly912 famly913 famly914 
famly921 famly922 famly923 famly924 
famly931 famly932 famly933 famly934 
famly941 famly942 famly943 famly944 
famly951 famly952 famly953 famly954 
famly961 famly962 famly963 famly964 
famly971 famly972 famly973 famly974 
famly981 famly982 famly983 famly984 
famly991 famly992 famly993 famly994
famly001 famly002 famly003 famly004;
BY newid;
RUN;

PROC DATASETS LIBRARY=work;
DELETE 
/*famly832 famly833 famly834*/
famly841 famly842 famly843 famly844
famly851 famly852 famly853 famly854 famly855
famly861 famly862 famly863 famly864
famly871 famly872 famly873 famly874
famly881 famly882 famly883 famly884
famly891 famly892 famly893 famly894
famly901 famly902 famly903 famly904
famly911 famly912 famly913 famly914
famly921 famly922 famly923 famly924
famly931 famly932 famly933 famly934
famly941 famly942 famly943 famly944
famly951 famly952 famly953 famly954 famly955
famly961 famly962 famly963 famly964
famly971 famly972 famly973 famly974
famly981 famly982 famly983 famly984 
famly991 famly992 famly993 famly994 
famly001 famly002 famly003 famly004;
RUN;

DATA cexdat;
SET cexdat1 cexdat2;
RUN;

PROC SORT DATA=cexdat;
BY newid;
RUN;

*%gunzipsq(~/jim/data,exp_adj_dat8486,all,all);

DATA cexdat;
MERGE cexdat(IN=in1) alldat.exp_adj_dat8486;
by newid;
IF in1;

ARRAY zeros food_home_adj food_away_adj oth_apl_hm_adj 
            oth_apl_away_adj oth_apl_oth_adj boats_adj;
DO OVER zeros;
   IF zeros=. THEN zeros=0;
END;
 
*******************************************************************
Adjust variables in 84-86 where ucc were moved around
see "Changes from..." in 87 codebook
*******************************************************************;
IF 841 LE qyear LE 864 THEN DO;
  fdhomepq=food_home_adj/2;
  fdhomecq=food_home_adj/2;
  fdawaypq=food_away_adj/2;
  fdawaycq=food_away_adj/2;

  sheltpq=sheltpq-((oth_apl_hm_adj+oth_apl_away_adj+oth_apl_oth_adj)/2); 
  sheltcq=sheltcq-((oth_apl_hm_adj+oth_apl_away_adj+oth_apl_oth_adj)/2); 
  owndwepq=owndwepq-((oth_apl_hm_adj)/2); 
  owndwecq=owndwecq-((oth_apl_hm_adj)/2); 
  othlodpq=othlodpq-((oth_apl_oth_adj)/2);
  othlodcq=othlodcq -((oth_apl_oth_adj)/2);
  rendwepq=rendwepq-((oth_apl_away_adj)/2);
  rendwecq=rendwecq-((oth_apl_away_adj)/2);
  hfurnpq=hfurnpq+((oth_apl_hm_adj+oth_apl_away_adj+oth_apl_oth_adj)/2);
  hfurncq=hfurncq+((oth_apl_hm_adj+oth_apl_away_adj+oth_apl_oth_adj)/2);

  transpq=transpq-((boats_adj)/2);
  transcq=transcq-((boats_adj)/2);
  othvehpq=othvehpq-((boats_adj)/2);
  othvehcq=othvehcq-((boats_adj)/2);
  entertpq=entertpq+((boats_adj)/2);
  entertcq=entertcq+((boats_adj)/2);

END;

*******************************************************************
Adjust food at home consumption from 84 to 87 because of a change
in wording. See food_adj_ratio.sas for calculation of adjustment factors
*******************************************************************;
**** SM's ****;
IF 831 LE qyear LE 874 AND sex_ref=2 AND fam_type=7 THEN DO; 
   totexppq2=totexppq+(fdhomepq*.182);
   totexpcq2=totexpcq+(fdhomecq*.182);
   foodpq2=foodpq+(fdhomepq*.182);
   foodcq2=foodcq+(fdhomecq*.182);
END;
**** SWNK's ****;
IF 831 LE qyear LE 874 AND sex_ref=2 AND fam_type=8 THEN DO; 
   totexppq2=totexppq+(fdhomepq*.303);
   totexpcq2=totexpcq+(fdhomecq*.303);
   foodpq2=foodpq+(fdhomepq*.303);
   foodcq2=foodcq+(fdhomecq*.303);
END;
**** MM's ****;
IF 831 LE qyear LE 874 AND (sex_ref=1 OR fam_type IN (1,2,3,4,5,6,9)) THEN DO; 
   totexppq2=totexppq+(fdhomepq*.115);
   totexpcq2=totexpcq+(fdhomecq*.115);
   foodpq2=foodpq+(fdhomepq*.115);
   foodcq2=foodcq+(fdhomecq*.115);
END;

RUN;

PROC DATASETS LIBRARY=work;
DELETE cexdat1 cexdat2;
RUN;

*****************************************************************
Merge housing data car data with the master dataset
*****************************************************************;
X "gunzip ~/jim/data/cex_state/sid84_85.sas7bdat.gz"; 
X "gunzip ~/jim/data/cex_state/sid86_92.sas7bdat.gz"; 

DATA alldat.famstep1;
MERGE cexdat(in=in1 rename= (BLS_URBN = temp1 STATE = temp2 cutenure=temp3 EDUCA2= temp4 EDUC_REF = temp5 FAM_TYPE = temp6 INCLASS = temp7 
MARITAL1 = temp12 RACE2 = temp13 REF_RACE = temp14 REGION
= temp15 SEX_REF = temp16 SMSASTAT = temp17 intvmo=temp22
intvyr=temp23))
state.sid84_85(RENAME=(state=state_1))
state.sid86_92(RENAME=(state=state_2))
;
BY newid;
IF in1;

BLS_URBN = temp1*1;
STATE = temp2*1;
cutenure = temp3*1;
EDUCA2 = temp4*1;
EDUC_REF = temp5*1;
FAM_TYPE = temp6*1;
INCLASS = temp7*1;
MARITAL1 = temp12*1;
RACE2 = temp13*1;
REF_RACE = temp14*1;
REGION = temp15*1;
SEX_REF = temp16*1;
SMSASTAT = temp17*1;
intvmo = temp22*1;
intvyr = temp23*1;
drop temp1-temp7 temp12-temp17 temp22-temp23;

IF 834 LE qyear LE 855 THEN state=state_1;
IF 861 LE qyear LE 924 THEN state=state_2;

lft5=floor(newid/10);
rt1=newid-lft5*10;

RUN;

PROC MEANS;
RUN;

PROC SORT; 
BY qyear;
PROC MEANS; 
BY qyear;
RUN;

*%gzipsq(work,famstep1,~/jim/data);

X "gzip -f ~/jim/data/cex_state/sid84_85.sas7bdat";
X "gzip -f ~/jim/data/cex_state/sid86_92.sas7bdat";
